/* ***********************************************************************
   *                                                                     *
   * triodefs.h                                                          *
   * Christian Zurhorst, BID R&D, 29 Jul. 1998                           *
   *                                                                     *
   * trigger IO sequencer definitions                                    *
   *                                                                     *
   ***********************************************************************

*/

#ifndef __TRIODEFS_H
#define __TRIODEFS_H

/* trigger IO sequencer properties                                   */

/* generic trigger IO sequencer properties */

#define B_TRIGIOSEQGENPROP_SIZE	 14

CLI typedef enum {
    B_TRIGIOSEQGEN_OUT_0,        /*@io0       */
    B_TRIGIOSEQGEN_OUT_1,        /*@io1       */
    B_TRIGIOSEQGEN_OUT_2,        /*@io2       */
    B_TRIGIOSEQGEN_OUT_3,        /*@io3       */
    B_TRIGIOSEQGEN_OUT_4,        /*@io4       */
    B_TRIGIOSEQGEN_OUT_5,        /*@io5       */
    B_TRIGIOSEQGEN_OUT_6,        /*@io6       */
    B_TRIGIOSEQGEN_OUT_7,        /*@io7       */
    B_TRIGIOSEQGEN_OUT_8,        /*@io8       */
    B_TRIGIOSEQGEN_OUT_9,        /*@io9       */
    B_TRIGIOSEQGEN_OUT_10,       /*@io10      */
    B_TRIGIOSEQGEN_OUT_11,       /*@io11      */
    B_TRIGIOSEQGEN_CTRC_PREL,    /*@cprel     */
    B_TRIGIOSEQGEN_CTRD_PREL     /*@dprel     */
} b_trigioseqgenproptype;

CLI /* DEF_START ~G_TRIGIO */
#define B_TRIGIO_INPONLY	0	/* @inponly */
#define B_TRIGIO_TOTEMPOLE	1	/* @totempole */
#define B_TRIGIO_OPENDRAIN	2	/* @opendrain */
CLI /* DEF_END */


/* integer based trigger io sequencer transient properties */

#define B_TRIGIOSEQTRANPROP_SIZE	 2

CLI typedef enum {
    B_TRIGIOSEQ_STATE,          /* @state     */
    B_TRIGIOSEQ_NEXTSTATE       /* @nextstate */
} b_trigioseqtranproptype;


/* string based trigger io sequencer transient properties */

#define B_TRIGIOSEQCONDPROP_SIZE	 19

CLI typedef enum {
    B_TRIGIOSEQ_XCOND,          /* @x         */
    B_TRIGIOSEQ_OUT_0,          /* @out0      */
    B_TRIGIOSEQ_OUT_1,          /* @out1      */
    B_TRIGIOSEQ_OUT_2,          /* @out2      */
    B_TRIGIOSEQ_OUT_3,          /* @out3      */
    B_TRIGIOSEQ_OUT_4,          /* @out4      */
    B_TRIGIOSEQ_OUT_5,          /* @out5      */
    B_TRIGIOSEQ_OUT_6,          /* @out6      */
    B_TRIGIOSEQ_OUT_7,          /* @out7      */
    B_TRIGIOSEQ_OUT_8,          /* @out8      */
    B_TRIGIOSEQ_OUT_9,          /* @out9      */
    B_TRIGIOSEQ_OUT_10,         /* @out10     */
    B_TRIGIOSEQ_OUT_11,         /* @out11     */
    B_TRIGIOSEQ_CDEC,           /* @cdec      */
    B_TRIGIOSEQ_CINC,           /* @cinc      */
    B_TRIGIOSEQ_CLOAD,          /* @cload     */
    B_TRIGIOSEQ_DDEC,           /* @ddec      */
    B_TRIGIOSEQ_DINC,           /* @dinc      */
    B_TRIGIOSEQ_DLOAD           /* @dload     */
} b_trigioseqtrancondproptype;



#endif




